#if !defined( _SPECIALISATION_GLOBALS_FXH )
#define _SPECIALISATION_GLOBALS_FXH

//---------------------------------------------------------------------------------
//
// HLSL header file contains macros and definitions for use
// with specialisable params
//

//---------------------------------------------------------------------------------
//
// 3DSMAX versions
//

#if defined( _3DSMAX_ )


//
// Macros for defining a parameter which embodies a specialisation choice
//
#define SPECIALISATION_PARAM( __paramName__, __UIName__, __specDefine__ )	\
bool __paramName__																												\
<																																					\
     string UIName = __UIName__;																					\
     bool export = false;																									\
     string specialisationDefine = __specDefine__;												\
> = false;

#define SPECIALISATION_PARAM_DEFAULTS_TRUE( __paramName__, __UIName__, __specDefine__ )	\
bool __paramName__																												\
<																																					\
     string UIName = __UIName__;																					\
     bool export = false;																									\
     string specialisationDefine = __specDefine__;												\
> = true;


//
// Macro for declaring to the exporter that a given input vertex stream's
// relevance is dependent on a parameter (this isn't possible in-place due
// to restrictions on annotating vert streams)
//
#define DECLARE_DEPENDENT_VERTEX_STREAM( __declName__, __streamName__, __streamSemantic__, __paramName__ )	\
uniform bool __declName__																																										\
<																																																						\
	string UIWidget = "None";																																									\
	bool export = false;																																											\
	string stream = #__streamName__;																																					\
	string streamSemantic = #__streamSemantic__;																															\
	string param = #__paramName__;																																						\
> = false;



//
// Macros for defining parameters whose export from Max depends on specialisation param
//

#define DEPENDENT_PARAM_START( __paramName__, __UIName__ )	\
__paramName__																								\
<																														\
	string UIName = __UIName__;


#define DEPENDENT_PARAM_START_SEMANTIC( __paramName__, __semantic__, __UIName__ )	\
__paramName__ : __semantic__																											\
<																																									\
	string UIName = __UIName__;


#define DEPENDENT_PARAM_END( __dependentParamName__ )	\
	string exportDependsOn = #__dependentParamName__;		\
>;


#define DEPENDENT_PARAM_MIN_MAX( __dtype__, __uiMin__, __uiMax__ )	\
	__dtype__ UIMin = __uiMin__;																			\
	__dtype__ UIMax = __uiMax__;                                  


#define DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
bool DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
DEPENDENT_PARAM_END( __dependentParamName__ )


#define DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
DEPENDENT_PARAM_END( __dependentParamName__ )

#define DEPENDENT_COLOUR_PARAM( __paramName__, __UIName__, __dependentParamName__ ) \
float4 DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
DEPENDENT_PARAM_END( __dependentParamName__ )


#define DEPENDENT_FLOAT_PARAM_MIN_MAX( __paramName__, __UIName__, __dependentParamName__, __uiMin__, __uiMax__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																													\
DEPENDENT_PARAM_MIN_MAX( float, __uiMin__, __uiMax__ )																														\
DEPENDENT_PARAM_END( __dependentParamName__ )


#define DEPENDENT_FLOAT_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __default__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																									\
	string exportDependsOn = #__dependentParamName__;																												\
> = __default__;


#define DEPENDENT_FLOAT_PARAM_MIN_MAX_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __uiMin__, __uiMax__, __default__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																																								\
DEPENDENT_PARAM_MIN_MAX( float, __uiMin__, __uiMax__ )																																									\
	string exportDependsOn = #__dependentParamName__;																																											\
> = __default__;


//
// Variants for declaring float4 params. In 3DSMAX these macros expand to 4x float params,
// with annotations telling the exporter to merge them into 1x float4. Ingame they expand
// to 1x float4 called __paramName__. This idiocy is required because 3dsmax peeks at the
// shader source, meaning that it can't handle token pasting preprocessor constructs.
//
#define FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__  )	\
float __paramNameX__	\
<	\
	string UIName = __UINameX__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameY__	\
<	\
	string UIName = __UINameY__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameZ__	\
<	\
	string UIName = __UINameZ__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameW__	\
<	\
	string UIName = __UINameW__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
>;


#define DEPENDENT_FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __dependentParamName__  )	\
float __paramNameX__	\
<	\
	string UIName = __UINameX__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameY__	\
<	\
	string UIName = __UINameY__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameZ__	\
<	\
	string UIName = __UINameZ__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
>;	\
\
float __paramNameW__	\
<	\
	string UIName = __UINameW__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
>;



#define DEPENDENT_FLOAT4_PARAM_DEFAULTED( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __dependentParamName__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float __paramNameX__	\
<	\
	string UIName = __UINameX__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
> = __defaultx__;	\
\
float __paramNameY__	\
<	\
	string UIName = __UINameY__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
> = __defaulty__;	\
\
float __paramNameZ__	\
<	\
	string UIName = __UINameZ__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
> = __defaultz__;	\
\
float __paramNameW__	\
<	\
	string UIName = __UINameW__;	\
	string UIWidget = "Spinner";	\
	string exportDependsOn = #__dependentParamName__;	\
	string mergeIntoParam = #__paramName__;	\
> = __defaultw__;


#define FLOAT4_PARAM_DEFAULTED( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float __paramNameX__	\
<	\
	string UIName = __UINameX__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
> = __defaultx__;	\
\
float __paramNameY__	\
<	\
	string UIName = __UINameY__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
> = __defaulty__;	\
\
float __paramNameZ__	\
<	\
	string UIName = __UINameZ__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
> = __defaultz__;	\
\
float __paramNameW__	\
<	\
	string UIName = __UINameW__;	\
	string UIWidget = "Spinner";	\
	bool export = true; \
	string mergeIntoParam = #__paramName__;	\
> = __defaultw__;


//
// In order to make shader code work the same with this setup, this macro creates a float4 from 4 floats
// in 3dsmax, and does nothing ingame (where the float4 has been declared as a shader constant).
//
#define DECLARE_MERGED_FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__ )	\
	float4 __paramName__ = float4( __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__ );


#define DEPENDENT_COLOURPICKER_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
float4 DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
DEPENDENT_PARAM_END( __dependentParamName__ )

#define DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
	string exportDependsOn = #__dependentParamName__;																	\
> = {__defaultx__, __defaulty__, __defaultz__, __defaultw__};




#define DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
texture DEPENDENT_PARAM_START_SEMANTIC( __paramName__, TEXTURE, __UIName__ )					\
DEPENDENT_PARAM_END( __dependentParamName__ )

#define DEPENDENT_CUBE_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamName__, __appEdit__ )	\
texture DEPENDENT_PARAM_START_SEMANTIC( __paramName__, TEXTURE, __UIName__ )							\
	string Type = "CUBE";																																		\
	bool export = __appEdit__;																															\
DEPENDENT_PARAM_END( __dependentParamName__ )


//
// Double-dependent parameters; 
//

#define BOTH_DEPENDENT_PARAM_END( __dependentParamNames__ )	\
	string exportDependsOnAllOf = #__dependentParamNames__;	\
>;

#define BOTH_DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
bool DEPENDENT_PARAM_START( __paramName__, __UIName__ )																	\
BOTH_DEPENDENT_PARAM_END( __dependentParamNames__ )

#define BOTH_DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																	\
BOTH_DEPENDENT_PARAM_END( __dependentParamNames__ )

#define BOTH_DEPENDENT_FLOAT_PARAM_MIN_MAX_DEFAULTED( __paramName__, __UIName__, __dependentParamNames__, __uiMin__, __uiMax__, __default__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																																								\
DEPENDENT_PARAM_MIN_MAX( float, __uiMin__, __uiMax__ )																																									\
string exportDependsOnAllOf = #__dependentParamNames__;																																									\
> = __default__;

#define BOTH_DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
texture DEPENDENT_PARAM_START_SEMANTIC( __paramName__, TEXTURE, __UIName__ )								\
BOTH_DEPENDENT_PARAM_END( __dependentParamNames__ )

#define BOTH_DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamNames__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 DEPENDENT_PARAM_START( __paramName__, __UIName__ )														\
string exportDependsOnAllOf = #__dependentParamNames__;															\
> = {__defaultx__, __defaulty__, __defaultz__, __defaultw__};


#define EITHER_DEPENDENT_PARAM_END( __dependentParamNames__ )	\
	string exportDependsOnOneOf = #__dependentParamNames__;		\
>;

#define EITHER_DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
bool DEPENDENT_PARAM_START( __paramName__, __UIName__ )																		\
EITHER_DEPENDENT_PARAM_END( __dependentParamNames__ )

#define EITHER_DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
float DEPENDENT_PARAM_START( __paramName__, __UIName__ )																		\
EITHER_DEPENDENT_PARAM_END( __dependentParamNames__ )

#define EITHER_DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
texture DEPENDENT_PARAM_START_SEMANTIC( __paramName__, TEXTURE, __UIName__ )									\
EITHER_DEPENDENT_PARAM_END( __dependentParamNames__ )



//
// Macros for bracketing dependent sections of code
//

#define DEPENDENT_CODE_START( __paramName__ )	\
	if ( __paramName__ )												\
	{

#define DEPENDENT_CODE_ELSE( __paramName__ )	\
	}																						\
	else																				\
	{

#define DEPENDENT_CODE_END( __paramName__ )	\
	}


//
// 2-param variants
//

// OR
#define DEPENDENT_CODE_START_OR( __paramName1__, __paramName2__ )	\
	if ( ( __paramName1__ ) || ( __paramName2__ ) )									\
	{

#define DEPENDENT_CODE_ELSE_OR( __paramName1__, __paramName2__ )	\
	}																																\
	else																														\
	{

#define DEPENDENT_CODE_END_OR( __paramName1__, __paramName2__ )	\
	}


// AND
#define DEPENDENT_CODE_START_AND( __paramName1__, __paramName2__ )	\
	if ( ( __paramName1__ ) && ( __paramName2__ ) )									\
	{

#define DEPENDENT_CODE_ELSE_AND( __paramName1__, __paramName2__ )	\
	}																																\
	else																														\
	{

#define DEPENDENT_CODE_END_AND( __paramName1__, __paramName2__ )	\
	}



//---------------------------------------------------------------------------------
//
// Engine versions
//

#else

#define SPECIALISATION_PARAM( __paramName__, __UIName__, __specDefine__ )
#define SPECIALISATION_PARAM_DEFAULTS_TRUE( __paramName__, __UIName__, __specDefine__ )
#define DECLARE_DEPENDENT_VERTEX_STREAM( __declName__, __streamName__, __streamSemantic__, __paramName__ )


#define DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
bool __paramName__																																\
<																																									\
	bool appEdit = true;																														\
>;

#define DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
float __paramName__																																	\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_COLOUR_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
float4 __paramName__																																	\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_FLOAT_PARAM_MIN_MAX( __paramName__, __UIName__, __dependentParamName__, __uiMin__, __uiMax__ )	\
float __paramName__																																					\
<																																														\
	bool appEdit = true;																																			\
>;

#define DEPENDENT_FLOAT_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __default__ )	\
float __paramName__																																												\
<																																																					\
	bool appEdit = true;																																										\
> = __default__;


#define DEPENDENT_FLOAT_PARAM_MIN_MAX_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __uiMin__, __uiMax__, __default__ )	\
float __paramName__																																					\
<																																														\
	bool appEdit = true;																																			\
> = __default__;


#define FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __dependentParamName__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define FLOAT4_PARAM_DEFAULTED( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_FLOAT4_PARAM_DEFAULTED( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__, __UINameX__, __UINameY__, __UINameZ__, __UINameW__, __dependentParamName__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define DECLARE_MERGED_FLOAT4_PARAM( __paramName__, __paramNameX__, __paramNameY__, __paramNameZ__, __paramNameW__ )

#define DEPENDENT_COLOURPICKER_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamName__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;

#define DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamName__ )	\
texture __paramName__ : TEXTURE																												\
<																																											\
	bool appEdit = true;																																\
>;


#define DEPENDENT_CUBE_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamName__, __appEdit__ )	\
texture __paramName__ : TEXTURE																												\
<																																											\
	bool appEdit = __appEdit__;																																\
>;


#define BOTH_DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
bool __paramName__																																\
<																																									\
	bool appEdit = true;																														\
>;

#define BOTH_DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
float __paramName__																																	\
<																																										\
	bool appEdit = true;																															\
>;

#define BOTH_DEPENDENT_FLOAT_PARAM_MIN_MAX_DEFAULTED( __paramName__, __UIName__, __dependentParamNames__, __uiMin__, __uiMax__, __default__ )	\
float __paramName__																																					\
<																																														\
	bool appEdit = true;																																			\
> = __default__;

#define BOTH_DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
texture __paramName__ : TEXTURE																												\
<																																											\
	bool appEdit = true;																																\
>;

#define BOTH_DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( __paramName__, __UIName__, __dependentParamNames__, __defaultx__, __defaulty__, __defaultz__, __defaultw__  )	\
float4 __paramName__																																\
<																																										\
	bool appEdit = true;																															\
>;


#define EITHER_DEPENDENT_BOOL_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
bool __paramName__																																\
<																																									\
	bool appEdit = true;																														\
>;

#define EITHER_DEPENDENT_FLOAT_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
float __paramName__																																	\
<																																										\
	bool appEdit = true;																															\
>;

#define EITHER_DEPENDENT_TEXTURE_PARAM( __paramName__, __UIName__, __dependentParamNames__ )	\
texture __paramName__ : TEXTURE																												\
<																																											\
	bool appEdit = true;																																\
>;


#define DEPENDENT_CODE_START( __paramName__ )
#define DEPENDENT_CODE_ELSE( __paramName__ )
#define DEPENDENT_CODE_END( __paramName__ )

#define DEPENDENT_CODE_START_OR( __paramName1__, __paramName2__ )
#define DEPENDENT_CODE_ELSE_OR( __paramName1__, __paramName2__ )
#define DEPENDENT_CODE_END_OR( __paramName1__, __paramName2__ )

#define DEPENDENT_CODE_START_AND( __paramName1__, __paramName2__ )
#define DEPENDENT_CODE_ELSE_AND( __paramName1__, __paramName2__ )
#define DEPENDENT_CODE_END_AND( __paramName1__, __paramName2__ )

#endif	// defined( _3DSMAX_ )


#endif	//  _SPECIALISATION_GLOBALS_FXH
